// 8Callback.cpp : 
//

#include	"stdafx.h"

#include	"8Callback.h"
#include	"8Connection.h"

#include	"misc.h"


UINT WINAPI IoCompletionCallback( void *arg )
{
	DWORD			dwIoSize;
	ULONG			key;
	BOOL			bSuccess;
	HANDLE			hIOCP = (HANDLE)arg;

	LPOVERLAPPED	lpOverlapped;

	while( TRUE )
	{
		bSuccess = GetQueuedCompletionStatus(
					hIOCP,
					&dwIoSize,
					&key,
					(LPOVERLAPPED*) &lpOverlapped,
					INFINITE
					);

		LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) lpOverlapped;

		if( bSuccess )
		{
			if( key == IOCP_SHUTDOWN )
				break;

			if( NULL != lpOverlapPlus )
			{
				lpOverlapPlus->dwBytes = dwIoSize;
				C8Connection * lpConnection = (C8Connection *) lpOverlapPlus->pConnection;
				lpConnection->DoIo( lpOverlapPlus );
			}
		}
		else
		{
			if( NULL == lpOverlapPlus )
			{
				printf( "Critical Error on GQCS()\n" );
			}
			else
			{
				C8Connection * lpConnection = (C8Connection *) lpOverlapPlus->pConnection;
				lpConnection->Close( lpOverlapPlus, TRUE );
			}
		}
	}

	return 0;
}
/*
VOID WINAPI IoCompletionCallback(
								 DWORD			dwErrorCode,
								 DWORD			dwBytesXfered, 
								 LPOVERLAPPED	lpOverlapped )
{
	if( 0 == dwErrorCode )
	{
		LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) lpOverlapped;
		if( 0 != lpOverlapPlus )
		{
			if( 0 != dwBytesXfered )
			{
				lpOverlapPlus->dwBytes = dwBytesXfered;
				QueueUserWorkItem( DoIoCallback, (PVOID) lpOverlapPlus, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION );
			}
			else
			{
				// Connection Closed
				QueueUserWorkItem( DoCloseCallback, (PVOID) lpOverlapPlus, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION );
			}
		}
		else
		{
			// Ͼ ȵǴ Ȳ̴.  µ  ü Ͱ  ¼ ΰ..
			printf( "Critical Error with IOCP\n" );
		}
	}
	else
	if( 0xC000013CL == dwErrorCode )
	{
		LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) lpOverlapped;
		if( 0 != lpOverlapPlus )
		{
			// Force Connection Closed
			QueueUserWorkItem( DoCloseCallback, (PVOID) lpOverlapPlus, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION );
		}
	}
	else
	if( 0xC0000120L == dwErrorCode )
	{
		LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) lpOverlapped;
		if( 0 != lpOverlapPlus )
		{
			// shutdown sequence initialized by server.
			QueueUserWorkItem( DoShutdownCallback, (PVOID) lpOverlapPlus, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION );
		}
	}
}

DWORD WINAPI DoIoCallback( PVOID pvContext )
{
	LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) pvContext;
	if( lpOverlapPlus == NULL ) return 0;
	C8Connection * lpConnection = (C8Connection *) lpOverlapPlus->pConnection;
	if( lpConnection == NULL ) return 0;

	if( 0 == lpConnection->DoIo(lpOverlapPlus) )
	{
		QueueUserWorkItem( DoCloseCallback, (PVOID) lpOverlapPlus, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION );
	}

	return FALSE;
}

DWORD WINAPI DoCloseCallback( PVOID pvContext )
{
	LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) pvContext;
	if( lpOverlapPlus == NULL )
		return 0;

	C8Connection * lpConnection = (C8Connection *) lpOverlapPlus->pConnection;
	if( lpConnection == NULL )
		return 0;

	lpConnection->Close( lpOverlapPlus, TRUE );

	return FALSE;
}

DWORD WINAPI DoShutdownCallback( PVOID pvContext )
{
	LPOVERLAPPEDPLUS lpOverlapPlus = (LPOVERLAPPEDPLUS) pvContext;
	if( lpOverlapPlus == NULL )
		return 0;

	C8Connection * lpConnection = (C8Connection *) lpOverlapPlus->pConnection;
	if( lpConnection == NULL )
		return 0;

	lpConnection->Shutdown( lpOverlapPlus, TRUE );

	return 0;
}

VOID WINAPI CheckConnectionCallback( PVOID pvContext, BOOLEAN fTimeout )
{
#ifdef _DEBUG
	DWORD dwTick = GetTickCount();
#endif

#ifdef _DEBUG
	printf( "CheckConnectionCallback(%d)\n", GetTickCount()-dwTick );
#endif

}
*/